package net.herit.svcplatform.pushservice.restdocs.commons.jwt;

import static org.springframework.restdocs.payload.PayloadDocumentation.requestFields;
import static org.springframework.restdocs.payload.PayloadDocumentation.fieldWithPath;
import static org.springframework.restdocs.payload.PayloadDocumentation.responseFields;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.ResultActions;

import com.fasterxml.jackson.core.JsonProcessingException;

import net.herit.svcplatform.pushservice.base.bases.RestDocsBaseWithSpringBoot;
import net.herit.svcplatform.pushservice.base.restdoc.RestDocAttributes;
import net.herit.svcplatform.pushservice.commons.dto.model.AccountModel;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.jwt.dto.TokenRenewalRequest;
import net.herit.svcplatform.pushservice.commons.jwt.dto.TokenRequest;

@Disabled
class JwtControllerTests extends RestDocsBaseWithSpringBoot {

	@Test
	@DisplayName("server json access token 발급")
	void requestServerAccessToken() throws Exception {
		TokenRequest request = new TokenRequest();

		request.setAccount(new AccountModel("login_id", "auth_token"));
		request.setApplicationId(1);
		request.setExpirationHour(3);
		request.setUserId("user_id");

		ResultActions result = this.mockMvc
				.perform(post("/api/jwt/server/request").contentType(MediaType.APPLICATION_JSON)
						.content(objectMapper.writeValueAsString(request)).headers(getTestHeader()));

		result.andDo(print()).andExpect(status().isOk())
				.andExpect(jsonPath("result.code").value(HttpResponseStatus.SUCCESS.getCode()))
				.andDo(this.document.document(this.defaultRequestHeader,
						requestFields(
								fieldWithPath("account.login_id").description("login_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")),
								fieldWithPath("account.auth_token").description("auth_token").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("user_id").description("user_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("application_id").description("application_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("expiration_hour").description("토큰 유효 시간").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""))
						),
						responseFields(
								fieldWithPath("result.code").description("결과 코드").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")),
								fieldWithPath("accessToken").description("ACCESS_TOKEN").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")),
								fieldWithPath("refreshToken").description("REFRESH_TOKEN").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")))));
	}

	@Test
	@DisplayName("client json access token 발급")
	void requestClientAccessToken() throws JsonProcessingException, Exception {
		TokenRequest request = new TokenRequest();

		request.setAccount(new AccountModel("login_id", "auth_token"));
		request.setApplicationId(1);
		request.setExpirationHour(3);
		request.setUserId("user_id");

		ResultActions result = this.mockMvc
				.perform(post("/api/jwt/client/request").contentType(MediaType.APPLICATION_JSON)
						.content(objectMapper.writeValueAsString(request)).headers(getTestHeader()));

		result.andDo(print()).andExpect(status().isOk())
				.andExpect(jsonPath("result.code").value(HttpResponseStatus.SUCCESS.getCode()))
				.andDo(this.document.document(this.defaultRequestHeader,
						requestFields(
								fieldWithPath("account.login_id").description("login_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")),
								fieldWithPath("account.auth_token").description("auth_token").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("user_id").description("user_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("application_id").description("application_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("expiration_hour").description("토큰 유효 시간").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""))
						),
						responseFields(
								fieldWithPath("result.code").description("결과 코드").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")),
								fieldWithPath("accessToken").description("ACCESS_TOKEN").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")),
								fieldWithPath("refreshToken").description("REFRESH_TOKEN").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")))));

	}

	@Test
	@DisplayName("server json access token 재발급 - refresh_token 이용")
	void renewalServerAccessToken() throws JsonProcessingException, Exception {
		TokenRenewalRequest request = new TokenRenewalRequest();

		request.setAccount(new AccountModel("login_id", "auth_token"));
		request.setApplicationId(1);
		request.setExpirationHour(3);
		request.setUserId("user_id");
		request.setTokenData(
				"eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJoZXJpdCIsInN1YiI6Imhlcml0V2VTb0ZseSIsImlhdCI6MTYxNTg3NDg5OCwiZXhwIjoxNjQ3NDEwODk4fQ.99RKbVfZN_k8FPH8XKMGfqMT-c48UV1MORl7ylrMCw0");

		ResultActions result = this.mockMvc
				.perform(post("/api/jwt/access/renewal").contentType(MediaType.APPLICATION_JSON)
						.content(objectMapper.writeValueAsString(request)).headers(getTestHeader()));

		result.andDo(print()).andExpect(status().isOk())
				.andExpect(jsonPath("result.code").value(HttpResponseStatus.SUCCESS.getCode()))
				.andDo(this.document.document(this.defaultRequestHeader,
						requestFields(
								fieldWithPath("account.login_id").description("login_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")),
								fieldWithPath("account.auth_token").description("auth_token").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("user_id").description("user_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("application_id").description("application_id").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("expiration_hour").description("토큰 유효 시간").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format("")), 
								fieldWithPath("token_data").description("REFRESH_TOKEN").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""))
						),
						responseFields(
								fieldWithPath("result.code").description("결과 코드").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")),
								fieldWithPath("accessToken").description("ACCESS_TOKEN").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")),
								fieldWithPath("refreshToken").description("REFRESH_TOKEN").attributes(
										RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""),
										RestDocAttributes.etc("")))));

	}
}
