package net.herit.svcplatform.pushservice.commons.exception;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.stream.Stream;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import net.herit.svcplatform.pushservice.base.bases.MockitoBase;
import net.herit.svcplatform.pushservice.commons.dto.model.FailModel;
import net.herit.svcplatform.pushservice.commons.dto.response.ErrorResponse;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.exception.CommonException;

class CommonExceptionTests extends MockitoBase {

	@MethodSource
	@ParameterizedTest
	@DisplayName("CommonException의 getErrorResponse 테스트")
	void getErrorResponseTest(HttpResponseStatus status) {
		CommonException commonException = new CommonException(status);
		
		ErrorResponse responseBody = new ErrorResponse();
		responseBody.setResult(
				new FailModel(
						status.getCode(),
						status.getDescription()
				));
		
		assertEquals(responseBody, commonException.getErrorResponse());
	}
	
	private static Stream<Arguments> getErrorResponseTest() {
		
		return Stream.of(
				Arguments.of(HttpResponseStatus.NOT_PROVIDE_SERVICE),
				Arguments.of(HttpResponseStatus.INVALID_PARAM),
				Arguments.of(HttpResponseStatus.DUPLICATED_CONTENTS),
				Arguments.of(HttpResponseStatus.SYSTEM_ERROR)
		);
	}
}
