package net.herit.svcplatform.pushservice.base.bases;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.test.context.ActiveProfiles;

import lombok.extern.slf4j.Slf4j;
import net.herit.svcplatform.pushservice.base.watcher.TestResultCounter;
import net.herit.svcplatform.pushservice.base.watcher.TestResultHandler;

@Slf4j
@ExtendWith(TestResultHandler.class)
@ActiveProfiles(value = {"local", "test"})
public class BaseTest {

	@AfterAll
	public static void printResultCount() {
		log.info("successCount: " + TestResultCounter.successCount);
		log.info(TestResultCounter.successDisplayNames.toString());
		log.info("------------------------------------------");
		
		log.info("failCount: " + TestResultCounter.failCount);
		log.info(TestResultCounter.failDisplayNames.toString());
		log.info("------------------------------------------");
		
		log.info("abortedCount: " + TestResultCounter.abortedDisplayNames);
		log.info(TestResultCounter.abortedDisplayNames.toString());
		log.info("------------------------------------------");
		
		log.info("disabledCount: " + TestResultCounter.disabledCount);
		log.info(TestResultCounter.disabledDisplayNames.toString());
	}
}
