package net.herit.svcplatform.pushservice.features.logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import javax.validation.Valid;

import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import io.swagger.annotations.ApiOperation;
import net.herit.svcplatform.pushservice.commons.auth.NonAuth;
import net.herit.svcplatform.pushservice.commons.dto.model.SuccessModel;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.exception.CommonException;
import net.herit.svcplatform.pushservice.commons.logger.LogTracer;

@RestController
public class LogTestController {
	private static final String ERROR = "error";

	@NonAuth
	@PostMapping("/api/1.0/post")
	@ApiOperation(value = "[Test] Json Post 테스트", notes = "참조 테이블 : 없음")
	@LogTracer(apiAppType = "postman", logType = "API", apiClass = "POST_TEST", svcClass = "JSON")
	public ResponseEntity<ResponseDto> postController(@RequestBody @Valid RequestDto requestBody)
			throws CommonException {

		if (requestBody.getData().getData().equals(ERROR)) {
			throw new CommonException(HttpResponseStatus.SYSTEM_ERROR);
		}

		return ResponseEntity.ok(responseDto());
	}

	@NonAuth
	@PostMapping(value = "/multiupload", produces = MediaType.APPLICATION_JSON_VALUE, consumes = {
			MediaType.MULTIPART_FORM_DATA_VALUE })
	public ResponseEntity<ResponseDto> multiUpload(@RequestParam(value = "data", required = true) @Valid String data,
			@RequestPart(value = "filename", required = true) MultipartFile[] files) throws CommonException {

		if (data.equals(ERROR)) {
			throw new CommonException(HttpResponseStatus.SYSTEM_ERROR);
		}

		return ResponseEntity.ok(responseDto());
	}

	@GetMapping("/api/1.0/get")
	@ApiOperation(value = "[Test] Json Get 테스트", notes = "참조 테이블 : 없음")
	@LogTracer(apiAppType = "postman", logType = "API", apiClass = "GET_TEST", svcClass = "JSON")
	public ResponseEntity<ResponseDto> getController(@RequestBody @Valid RequestDto requestBody)
			throws CommonException {

		if (requestBody.getData().getData().equals(ERROR)) {
			throw new CommonException(HttpResponseStatus.SYSTEM_ERROR);
		}

		ResponseDto dto = new ResponseDto(new SuccessModel());
		return ResponseEntity.ok(dto);

	}

	@GetMapping(value = "/api/1.0/get/form/urlencoded", produces = MediaType.APPLICATION_JSON_VALUE, consumes = {
			MediaType.APPLICATION_FORM_URLENCODED_VALUE })
	@ApiOperation(value = "[Test] form-urlencoded Get 테스트", notes = "참조 테이블 : 없음")
	@LogTracer(apiAppType = "postman", logType = "API", apiClass = "GET_TEST", svcClass = "FORM_URL_ENCODED")
	public ResponseEntity<ResponseDto> getFormUrlEncodedController(@RequestBody MultiValueMap<String, String> formData)
			throws CommonException {

		String data = formData.getFirst("data");

		if (data == null || data.equals(ERROR)) {
			throw new CommonException(HttpResponseStatus.SYSTEM_ERROR);
		}

		return ResponseEntity.ok(responseDto());
	}

	@NonAuth
	@ApiOperation(value = "[Test] healthcheck Get&Post 테스트", notes = "참조 테이블 : 없음")
	@RequestMapping(method = { RequestMethod.GET, RequestMethod.POST }, value = "/api/1.0/healthcheck")
	@LogTracer(apiAppType = "postman", logType = "API", apiClass = "GET&POST_TEST", svcClass = "CONTENT_TYPE_NULL")
	public ResponseEntity<ResponseDto> healthCheck() {

		return ResponseEntity.ok(responseDto());
	}

	private ResponseDto responseDto() {
		return new ResponseDto(new SuccessModel());
	}

	/**
	 * Response 로그 확인을 위한 multipart_form_data 응답 컨트롤러.
	 * 파일의 경우는 컴퓨터에 따라 없을수도있으므로 테스트는 따로 만들지 않음.
	 * @return
	 * @throws FileNotFoundException 
	 */
	@Deprecated
	@GetMapping(value = "/filedownload")
	public ResponseEntity<Resource> filedownload() throws FileNotFoundException {
		File file = new File("C:\\Users\\mysend\\Pictures\\energyplus.PNG");
		InputStreamResource resource = new InputStreamResource(new FileInputStream(file));

		return ResponseEntity.ok()
				.header(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"" + file.getName() + "\"")
				.contentLength(file.length()).contentType(MediaType.parseMediaType("application/octet-stream"))
				.body(resource);

	}

}
