package net.herit.svcplatform.pushservice.features.feign;

import javax.servlet.http.HttpServletRequest;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import lombok.RequiredArgsConstructor;

@RestController
@RequiredArgsConstructor
public class FeignTestController {
	private final CallLogger callLogger;
	
	@RequestMapping(value = "/feign/test/post", method = {RequestMethod.POST})
	public ResponseEntity<ParamB> feignSamplePost(
			HttpServletRequest request, 
			ParamA data) {
		callLogger.info("FeignSampleController..............");
		
		return ResponseEntity.ok(new ParamB(request.getHeader("name")));
	}

	@RequestMapping(value = "/feign/test/get", method = {RequestMethod.GET, RequestMethod.POST})
	public ResponseEntity<ParamB> feignSampleGet(
			HttpServletRequest request, 
			@RequestBody ParamA data) {
		callLogger.info("FeignSampleController..............");
		return ResponseEntity.ok(new ParamB(request.getHeader("name")));
	}

}
