package net.herit.svcplatform.pushservice.features.auth;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiOperation;
import net.herit.svcplatform.pushservice.commons.auth.NonAuth;
import net.herit.svcplatform.pushservice.commons.dto.model.SuccessModel;
import net.herit.svcplatform.pushservice.commons.dto.request.RequestSession;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.features.logger.DefaultModel;
import net.herit.svcplatform.pushservice.features.logger.ResponseDto;
import lombok.RequiredArgsConstructor;

@RestController
@RequiredArgsConstructor
public class AuthTestController {
	private final CallLogger callLogger;
	
	@Autowired
	private RequestSession requestSession;
	
	@PostMapping("/api/1.0/auth/test")
	@ApiOperation(value = "[Test] auth Post 테스트", notes = "참조 테이블 : 없음")
	public ResponseEntity<ResponseDto> authTestController(
			@RequestBody AuthRequestDto requestBody) {
		
		callLogger.info("loginId: {}", requestSession.getBody().getAccount().getLoginId());
		callLogger.info("authToken: {}", requestSession.getBody().getAccount().getAuthToken());

		callLogger.info("xServiceId: {}", requestSession.getHeader().getXServiceId());
		callLogger.info("xAppType: {}", requestSession.getHeader().getXAppType());
		callLogger.info("xTerminalId: {}", requestSession.getHeader().getXTerminalId());
		
		callLogger.info("uri: {}", requestSession.getUri());
		
		return ResponseEntity.ok(new ResponseDto(new SuccessModel()));
	}
	
	@NonAuth
	@PostMapping("/api/1.0/auth/non/test")
	@ApiOperation(value = "[Test] non auth Post 테스트", notes = "참조 테이블 : 없음")
	public ResponseEntity<ResponseDto> nonAuthTestController(
			@RequestBody AuthRequestDto requestBody) {
		
		DefaultModel model = new DefaultModel();
		model.setData("it is data");
		
		return ResponseEntity.ok(new ResponseDto(new SuccessModel()));
	}

}
