package net.herit.svcplatform.pushservice.commons.validation.header;

import javax.servlet.http.HttpServletRequest;

import net.herit.svcplatform.pushservice.commons.dto.request.RequestHeader;
import net.herit.svcplatform.pushservice.commons.util.StaticUtils;

public class RequestHeaderValidation {
	
	private RequestHeaderValidation() {
		throw new IllegalStateException("Utility class");
	}
	
	public static boolean isValid(HttpServletRequest request) {
		RequestHeader requestHeader = new RequestHeader(request);
		boolean result = false;
		
		try {
			result = headerLengthCheck(requestHeader);
		} catch (Exception e) {
			return false;
		}
		
		return result;
	}
	
	protected static boolean headerLengthCheck(RequestHeader requestHeader) throws Exception {
		String xServiceId = requestHeader.getXServiceId();
		String xTerminalId = requestHeader.getXTerminalId();
		String xAppType = requestHeader.getXAppType();
		
		return StaticUtils.checkSize(0, 20, xServiceId) && 
				StaticUtils.checkSize(0, 50, xTerminalId) && 
				StaticUtils.checkSize(0, 50, xAppType)
		;
	}
	
}
