package net.herit.svcplatform.pushservice.commons.util;

public class StaticUtils {
	
	private StaticUtils() {
		throw new IllegalAccessError("Utility class");
	}

	public static boolean checkSize(int min, int max, String data) throws Exception {
		
		if (data == null) return false;
		
		int size = data.length();
		if (min < 0) min = 0;
		if (min > max) throw new Exception("'min' 값은 'max'값 보다 클 수 없습니다.");
		if (max <= 0) throw new Exception("'max' 값은 0보다 작거나 같을 수 없습니다.");
		if (size > max || size < min) return false;
		
		return true;
	}
	
	public static boolean checkNotEmpty(String... strings) {
		
		for(String value : strings) {
			if(value == null || "".equals(value)) {
				return false;
			}
		}
		
		return true;
	}

}
