package net.herit.svcplatform.pushservice.commons.util;

import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.stereotype.Component;

import java.util.UUID;

@Component
public class IdGenerator {
    private final DateTimeUtil dateTimeUtil;

    public IdGenerator(DateTimeUtil dateTimeUtil) {
        this.dateTimeUtil = dateTimeUtil;
    }

    /**
     * 알파벳(대소문자)+숫자로 조합된 문자열을 반환합니다.
     *
     * @param length : 문자열 길이(최소값 5, 최대값 64)
     * @return
     */
    public String makeRandomAlphaNumeric(int length) {
        if(length < 5) {
            length = 5;
        }
        if(length > 64) {
            length = 64;
        }
        return RandomStringUtils.randomAlphanumeric(length);
    }

    /**
     * 알파벳(대소문자)으로 조합된 문자열을 반환합니다.
     *
     * @param length : 문자열 길이(최소값 5, 최대값 64)
     * @return
     */
    public String makeRandomAlpha(int length) {
        if(length < 5) {
            length = 5;
        }
        if(length > 64) {
            length = 64;
        }
        return RandomStringUtils.randomAlphanumeric(length);
    }

    /**
     * UUID 를 생성해서 반환합니다.
     *
     * @return
     */
    public String makeUUID() {
        return UUID.randomUUID().toString();
    }

    /**
     * UUID 를 생성해서 하이픈(-)을 제거한 UUID 를 반환합니다.
     *
     * @return
     */
    public String makeUUIDWithoutHypen() {
        return makeUUID().replaceAll("-", "");
    }

    /**
     * 랜덤으로 생성된 트랜젝션 아이디를 반환합니다.
     * 포맷 : yyyyMMddHHmmss.12자리영문(대소문자)숫자조합
     * @return
     */
    public String makeTxId() {
        return dateTimeUtil.getNow_yyyyMMddHHmmss() +"."+ makeRandomAlphaNumeric(5);
    }
}
