package net.herit.svcplatform.pushservice.commons.util;

import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Component
public class DateTimeUtil {
    DateTimeFormatter yyyyMMddHHmm = DateTimeFormatter.ofPattern("uuuuMMddHHmm", Locale.KOREA);
    DateTimeFormatter yyyyMMddHHmmss = DateTimeFormatter.ofPattern("uuuuMMddHHmmss", Locale.KOREA);
    DateTimeFormatter yyyyMMddHHmmssSSS = DateTimeFormatter.ofPattern("uuuuMMddHHmmssSSS", Locale.KOREA);

    public String getNow_yyyyMMddHHmmssSSS() {
        return LocalDateTime.now().format(yyyyMMddHHmmssSSS);
    }
    public String getNow_yyyyMMddHHmmss() {
        return LocalDateTime.now().format(yyyyMMddHHmmss);
    }
    public String getNow_yyyyMMddHHmm() {
        return LocalDateTime.now().format(yyyyMMddHHmm);
    }
    public long getNow_epochMillis() {
        return Instant.now().toEpochMilli();
    }
    public long getNow_epochNano() {
        return System.nanoTime();
    }

    public List<String> getPrevDateTimes(String dateTime, int prevDays) {
        List<String> prevDateTimes = new ArrayList<>();

        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
        LocalDateTime drStartTimeLocal = LocalDateTime.parse(dateTime, dateTimeFormatter);
        for(int i=1; i<=prevDays; i++) {
            prevDateTimes.add(drStartTimeLocal.minusDays(i).format(dateTimeFormatter));
        }
        return prevDateTimes;
    }
}
