package net.herit.svcplatform.pushservice.commons.logger.dto;

import net.herit.common.logger.obj.abst.AbstractCallLogObject;
import net.herit.svcplatform.pushservice.commons.dto.enums.AppInfos;

import javax.servlet.http.HttpServletRequest;

public class CallObject extends AbstractCallLogObject implements Cloneable {

	public void init() {
		super.appName = AppInfos.APP_NAME;
		setCallId(AppInfos.SVC_ID);
		setSvcId(AppInfos.SVC_ID);
	}

	public CallObject request(HttpServletRequest request) {
		
		String svcId = request.getHeader("X-SERVICE-ID");
		String transactionId = request.getHeader("X-TRANSACTION-ID");
		String appName = request.getHeader("X-APP-TYPE");
		super.appName = appName;
		
		setCallId(generateCallString());
		setTransactionId(transactionId);
		setSvcId(svcId);
		
		return this;
	}
	
	@Override
	public int objId() {
		return System.identityHashCode(this);
	}

	@Override
	public String toLog() {
		StringBuilder sb = new StringBuilder();
		
		sb.append("[").append(getDirection()).append("]");
		sb.append("[").append(getCallId()).append("]");
		sb.append("[").append(getTransactionId()).append("]");
		sb.append("[").append(getUserId()).append("]");
		sb.append("[").append(getMsgType()).append("]");
		sb.append("[").append(getSvcId()).append("]");
		
		return sb.toString();
	}

	@Override
	public AbstractCallLogObject cloneObj() throws CloneNotSupportedException {
		return (CallObject) this.clone();
	}
	
	@Override
	protected Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
}
