package net.herit.svcplatform.pushservice.commons.logger;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import net.herit.svcplatform.pushservice.commons.dto.response.ErrorResponse;
import net.herit.svcplatform.pushservice.commons.logger.dto.OmsObject;
import net.herit.svcplatform.pushservice.commons.util.DateUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.herit.common.logger.context.HeritLoggerContext;
import net.herit.common.logger.obj.abst.AbstractOmsObject;

@Slf4j
@Component
@RequiredArgsConstructor
public class OmsLogger {
	private final DateUtil dateUtil;
	private final CallLogger callLogger;
	private final ObjectMapper objectMapper;
	
	@Autowired
	private OmsObject oms;

	public void write() {
		oms.setSeqId();
		oms.setLogTime(dateUtil.generateTimeStamp("yyyyMMddHHmmssSSS"));
		log.info(oms.toLog());
	}
	
	public void write(AbstractOmsObject oms){
		oms.setSeqId();
		oms.setLogTime(dateUtil.generateTimeStamp("yyyyMMddHHmmssSSS"));
		log.info(oms.toLog());
	}

    public void writeErrorOms(ErrorResponse responseBody, int code, int resCode) {
    	try {
			callLogger.info("{}", objectMapper.writeValueAsString(responseBody));
		} catch (JsonProcessingException e) {
			callLogger.error("call log fail");
		}
		
    	oms.resultCode(code).httpStatus(resCode)
			.responseTime(dateUtil.generateTimeStamp("yyyyMMddHHmmssSSS"));
		write();
		HeritLoggerContext.resetAttributes(); // 로그 객체 초기화
    }
    
}
