package net.herit.svcplatform.pushservice.commons.jwt.dto;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;

import net.herit.svcplatform.pushservice.commons.dto.model.AccountModel;
import lombok.Data;

@Data
public class TokenRenewalRequest {
	
	@Valid @NotNull
	private AccountModel account;	
	@Valid @NotNull @JsonProperty("user_id")
	private String userId;
	@Valid @Min(value=1) @JsonProperty("application_id")
	private int applicationId;
	@Valid @Min(value=1)
	@JsonProperty("expiration_hour")
	private int expirationHour;
	
	/**
	 * ACCESS_TOKEN이 아닌 REFRESH_TOKEN
	 */
	@NotNull
	@JsonProperty("token_data")
	private String tokenData;

}
