package net.herit.svcplatform.pushservice.commons.jwt;

import org.springframework.stereotype.Service;

import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.exception.CommonException;
import net.herit.svcplatform.pushservice.commons.jwt.dto.ResultTokenDto;
import net.herit.svcplatform.pushservice.commons.jwt.dto.TokenRenewalRequest;
import net.herit.svcplatform.pushservice.commons.jwt.dto.TokenRequest;
import net.herit.svcplatform.pushservice.commons.jwt.properties.JwtProperties;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.commons.util.JwtUtil;
import lombok.RequiredArgsConstructor;

//TODO DB 작업은 따로 되어있지 않으므로, DB 인증과정 추가 필요함 -> 토큰 발급 API이므로 Swagger에서 사용할 수 없도록 경로 지정
@Service
@RequiredArgsConstructor
public class JwtService {
	private final CallLogger callLogger;
	private final JwtUtil jwtTokenUtil;
	private final JwtProperties jwtProperties;

	public ResultTokenDto requestServerAccessToken(TokenRequest tokenRequest) {
		callLogger.info("net.herit.svcplatform.pushservice.commons.jwt.JwtTokenService.requestServerAccessToken()");

		int refreshTokenExpiration = Integer.parseInt(jwtProperties.getRefreshTokenExpirationHour());

		String accessToken = jwtTokenUtil.createServerAccessToken(null, tokenRequest.getExpirationHour());
		String refreshToken = jwtTokenUtil.createRefreshToken(null, refreshTokenExpiration);
		
		return new ResultTokenDto(accessToken, refreshToken);
	}
	
	public ResultTokenDto requestClientAccessToken(TokenRequest tokenRequest) {
		callLogger.info("net.herit.svcplatform.pushservice.commons.jwt.JwtTokenService.requestClientAccessToken()");

		int refreshTokenExpiration = Integer.parseInt(jwtProperties.getRefreshTokenExpirationHour());

		String accessToken = jwtTokenUtil.createClientAccessToken(null, tokenRequest.getExpirationHour());
		String refreshToken = jwtTokenUtil.createRefreshToken(null, refreshTokenExpiration);

		return new ResultTokenDto(accessToken, refreshToken);
		
	}
	
	public ResultTokenDto renewalServerAccessToken(TokenRenewalRequest tokenRenewalRequest) {

		try {
			jwtTokenUtil.decodeRefreshToken(tokenRenewalRequest.getTokenData());
		} catch(Exception e) {
			throw new CommonException(HttpResponseStatus.INVALID_JWT_TOKEN);
		}
		
		String accessToken = jwtTokenUtil.createServerAccessToken(null, tokenRenewalRequest.getExpirationHour());
		
		// TODO refresh_token도 갱신해서 응답할지 아니면 기존 refresh_token으로 응답할지 확인 필요
		return new ResultTokenDto(accessToken, tokenRenewalRequest.getTokenData());
	}

}
