package net.herit.svcplatform.pushservice.commons.jwt;

import javax.validation.Valid;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import net.herit.svcplatform.pushservice.commons.auth.NonAuth;
import net.herit.svcplatform.pushservice.commons.jwt.dto.ResultTokenDto;
import net.herit.svcplatform.pushservice.commons.jwt.dto.TokenRenewalRequest;
import net.herit.svcplatform.pushservice.commons.jwt.dto.TokenRequest;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import lombok.RequiredArgsConstructor;

// TODO DB 작업은 따로 되어있지 않으므로, DB 인증과정 추가 필요함 -> 토큰 발급 API이므로 Swagger에서 사용할 수 없도록 경로 지정
@RestController
@RequiredArgsConstructor
public class JwtController {
	private final CallLogger callLogger;
	private final JwtService jwtTokenService;

	@NonAuth
	@PostMapping("/api/jwt/server/request")
	public ResponseEntity<ResultTokenDto> requestServerAccessToken(@Valid @RequestBody TokenRequest requestBody) {
		callLogger.info("net.herit.svcplatform.pushservice.commons.jwt.JwtTokenController.requestServerAccessToken()");
		
		return ResponseEntity.ok(jwtTokenService.requestServerAccessToken(requestBody));
	}

	@NonAuth
	@PostMapping("/api/jwt/client/request")
	public ResponseEntity<ResultTokenDto> requestClientAccessToken(@Valid @RequestBody TokenRequest requestBody) {
		callLogger.info("net.herit.svcplatform.pushservice.commons.jwt.JwtTokenController.requestClientAccessToken()");
		
		return ResponseEntity.ok(jwtTokenService.requestClientAccessToken(requestBody));
	}

	@NonAuth
	@PostMapping("/api/jwt/access/renewal")
	public ResponseEntity<ResultTokenDto> renewalServerAccessToken(@Valid @RequestBody TokenRenewalRequest requestBody) {
		callLogger.info("net.herit.svcplatform.pushservice.commons.jwt.JwtTokenController.renewalServerAccessToken()");
		
		return ResponseEntity.ok(jwtTokenService.renewalServerAccessToken(requestBody));
	}

}
