package net.herit.svcplatform.pushservice.commons.exception;

import net.herit.svcplatform.pushservice.commons.dto.model.FailModel;
import net.herit.svcplatform.pushservice.commons.dto.response.ErrorResponse;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public class CommonException extends RuntimeException {

    private static final long serialVersionUID = -293606853491213392L;
    private final Integer code;
    private final Integer resCode;
    private final String description;

    public ErrorResponse getErrorResponse(){
        ErrorResponse responseBody = new ErrorResponse();

        responseBody.setResult(
            new FailModel(code, description)
        );

        return responseBody;
    }
    
    public CommonException(HttpResponseStatus httpResponseStatus) {
    	this.code = httpResponseStatus.getCode();
    	this.resCode = httpResponseStatus.getResCode();
    	this.description = httpResponseStatus.getDescription();
    }
    
    public CommonException(Integer code, String description) {
    	this.code = code;
    	this.resCode = HttpResponseStatus.findResCodeByCode(code);
    	this.description = description;
    }

}