package net.herit.svcplatform.pushservice.commons.exception;

import net.herit.svcplatform.pushservice.commons.dto.model.FailModel;
import net.herit.svcplatform.pushservice.commons.dto.response.ErrorResponse;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;

public class AopException extends RuntimeException {

	private static final long serialVersionUID = 2125940198299377339L;
	
	private int resultCode;
	
	/**
	 * 고유한 결과 코드값을 입력해야한다.
	 * @param resultCode
	 */
	public AopException(HttpResponseStatus status) {
		super(status.getDescription());
		this.resultCode = status.getCode();
	}
	
	public AopException(String resultCode) {
		super(resultCode);
		this.resultCode = Integer.parseInt(resultCode);
	}
	
	public AopException(int resultCode) {
		super(String.valueOf(resultCode));
		this.resultCode = resultCode;
	}

	public ErrorResponse getErrorResponse() throws Exception {

		ErrorResponse responseBody = new ErrorResponse();
		responseBody.setResult(new FailModel(this.resultCode, HttpResponseStatus.findHttpResponseStatusByCode(this.resultCode).getDescription()));

		return responseBody;
	}
	
	public HttpResponseStatus getHttpResponseStatus() throws CommonException {
		return HttpResponseStatus.findHttpResponseStatusByCode(this.resultCode);
	}

}
