package net.herit.svcplatform.pushservice.commons.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import net.herit.svcplatform.pushservice.commons.auth.NonAuth;
import net.herit.svcplatform.pushservice.commons.dto.response.SuccessResponse;
import net.herit.svcplatform.pushservice.commons.logger.LogTracer;

@RestController
public class HealthCheckController {

	@GetMapping("/api/healthcheck")
	@LogTracer(apiAppType = "", apiClass = "HC01", svcClass = "HC01")
	public ResponseEntity<SuccessResponse> healthCheckGet() {
		return ResponseEntity.ok(new SuccessResponse());
	}
	
	@NonAuth
	@PostMapping("/api/healthcheck")
	@LogTracer(apiAppType = "", apiClass = "HC01", svcClass = "HC01")
	public ResponseEntity<SuccessResponse> healthCheckPost() {
		return ResponseEntity.ok(new SuccessResponse());
	}
		
}
