package net.herit.svcplatform.pushservice.commons.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import net.herit.svcplatform.pushservice.commons.dto.response.ErrorResponse;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.exception.CommonException;
import net.herit.svcplatform.pushservice.commons.logger.OmsLogger;
import net.herit.svcplatform.pushservice.commons.logger.dto.OmsObject;


@RestController
@RequestMapping("${server.error.path:${error.path:/error}}")
public class ErrorController extends AbstractErrorController {

	@Autowired
	private OmsLogger omsLogger;
	
	@Autowired
	private OmsObject omsObj;
	
	public ErrorController(ErrorAttributes errorAttributes) {
		super(errorAttributes);
	}

	@Override
	public String getErrorPath() {
		return this.getErrorPath();
	}
    
	@RequestMapping
	public ResponseEntity<ErrorResponse> error(HttpServletRequest request) {
		String uri = (String) request.getAttribute("svc_uri");
		
		omsObj.uri(uri);
		
		HttpStatus status = getStatus(request);
	    HttpHeaders httpHeaders = new HttpHeaders();
	    httpHeaders.add("Content-Type", "application/json");
	    
	    String description = getDescription(status, uri);

	    ErrorResponse responseBody = new CommonException(
							HttpResponseStatus.findResCodeByCode(status.value()), 
							description
						).getErrorResponse();
	    
	    /**
	     * Swagger 이용시에도 404 에러가 발생하는데, 원인을 알 수 없어 svc_uri 값이 설정되어 있는 경우에만 로그를 출력하도록 설정
	     */
	    if (uri != null) {
	    	omsLogger.writeErrorOms(
	    			responseBody, 
	    			HttpResponseStatus.NOT_PROVIDE_SERVICE.getCode(), 
	    			HttpResponseStatus.NOT_PROVIDE_SERVICE.getResCode());
	    }

		return new ResponseEntity<>(responseBody, httpHeaders, status);
	}
	
	private String getDescription(HttpStatus status, Object uri) {
		String description = null;
		
		if(status.value() == HttpResponseStatus.NOT_PROVIDE_SERVICE.getResCode()) {
	    	description = HttpResponseStatus.NOT_PROVIDE_SERVICE.getDescription() + uri;
		} else {
			description = status.getReasonPhrase();
		}
		
		return description;
	}
}
