package net.herit.svcplatform.pushservice.commons.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfig {
    @Value(value = "${thread-pool.core-size}")
    int corePoolSize;
    @Value(value = "${thread-pool.max-size}")
    int maxPoolSize;
    @Value(value = "${thread-pool.queue-capacity}")
    int queueCapacity;

    @Bean(name = "push-request-executor")
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(queueCapacity);
        threadPoolTaskExecutor.setThreadNamePrefix("push-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

}
