package net.herit.svcplatform.pushservice.commons.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.context.annotation.RequestScope;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import net.herit.svcplatform.pushservice.commons.dto.request.RequestSession;

@Configuration
public class RegisterConfig {

	@Value("${logging.call.multiline}")
	private boolean multiline;
	
	@Bean
	@RequestScope
	public RequestSession requestSession() {
		return new RequestSession();
	}
	
	@Bean
	public ObjectMapper objectMapper() {
		Jackson2ObjectMapperBuilder builder = Jackson2ObjectMapperBuilder.json();
		builder.featuresToDisable(SerializationFeature.FAIL_ON_EMPTY_BEANS, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
		
		if(multiline) {
			builder.featuresToEnable(SerializationFeature.INDENT_OUTPUT);
		}
		
		return builder.build();
	}
}
