package net.herit.svcplatform.pushservice.commons.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import net.herit.svcplatform.pushservice.commons.logger.interceptor.LoggerInterceptor;
import net.herit.svcplatform.pushservice.commons.validation.header.HeaderCheckInterceptor;

@Configuration
public class InterceptorConfig implements WebMvcConfigurer{

	@Autowired
	private LoggerInterceptor loggerInterceptor;

	@Autowired
	private HeaderCheckInterceptor headerCheckInterceptor;
	
	@Override
	public void addInterceptors(InterceptorRegistry registry) {

		String excludeError = "/error";
		String excludeRestDocs = "/api/1.0/*/docs/*.html";
		String[] excludePathPatterns = {
				"/swagger-ui.html", 
				"/v2/api-docs", 
				"/webjars/**", 
				"/swagger-resources/**", 
				"/", 
				"/csrf", 
				"/favicon.ico", 
				"/healthcheck"
		};
		
		String feignApi = "/feign/test/*";
		
		registry.addInterceptor(loggerInterceptor)
				.addPathPatterns("/**")
				.excludePathPatterns(excludeError)
				.excludePathPatterns(excludeRestDocs)
				.excludePathPatterns(excludePathPatterns)
		;
		
		registry.addInterceptor(headerCheckInterceptor)
				.addPathPatterns("/**")
				.excludePathPatterns(excludeError)
				.excludePathPatterns(excludePathPatterns)
				.excludePathPatterns(excludeRestDocs)
				.excludePathPatterns(feignApi)
		;
	}
	
}
