#!/bin/sh

JAVA_PATH=/usr/local/sbin/java
HERE_PATH=/svc/app/
SERVICE_NAME=pushservice
PID_FILE=${HERE_PATH}/pid/${SERVICE_NAME}.pid
JAR_NAME=${SERVICE_NAME}.jar

## GC config
GC_LOG_PATH=/logs/gcLog/${SERVICE_NAME}/gc.log
JAVA_OPTION="${JAVA_OPTION} -Xms512M -Xmx512M -XX:MaxMetaspaceSize=256m" 
JAVA_OPTION="${JAVA_OPTION} -XX:+UseConcMarkSweepGC" 
JAVA_OPTION="${JAVA_OPTION} -verbose:gc -XX:+PrintGCTimeStamps -XX:+PrintHeapAtGC -XX:+PrintGCDetails" 
JAVA_OPTION="${JAVA_OPTION} -Xloggc:${GC_LOG_PATH}" 
JAVA_OPTION="${JAVA_OPTION} -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=9 -XX:GCLogFileSize=20m" 

## Spring config
SPRING_OPTION="${SPRING_OPTION} -Dspring.config.location=../config/ -Dspring.profiles.active=dev"

case $1 in
start)
  echo ""
  PCOUNT=`ps -ef |grep ${SERVICE_NAME} |grep -v grep |wc -l`
  if [ $PCOUNT -ne 0 ]
  then
    echo "already run ${SERVICE_NAME} . pid:`cat $PID_FILE`"
  else
    ${JAVA_PATH} -classpath .:../config ${SPRING_OPTION} ${JAVA_OPTION}  -DAppName=${SERVICE_NAME} -jar ${JAR_NAME} 1>&2 &

    echo "$!" > ${PID_FILE}
    echo "START ${SERVICE_NAME}. pid:$!"
    ps -ef |grep `cat ${PID_FILE}` |grep -v grep
  fi
  echo ""
  ;;
stop)
  echo ""
  kill -9 `cat ${PID_FILE}`
  echo "STOP ${SERVICE_NAME}. pid:`cat ${PID_FILE}`"
  echo ""
  ;;
status)
  echo ""
  echo "STATUS ${SERVICE_NAME}."
  ps -ef |grep ${SERVICE_NAME} |grep -v grep |grep `cat ${PID_FILE}`
  echo ""
  ;;
*)
  echo "./run.sh start|stop|status"
esac
