package net.herit.svcplatform.pushservice.restdocs.logger;

import static org.springframework.restdocs.payload.PayloadDocumentation.fieldWithPath;
import static org.springframework.restdocs.payload.PayloadDocumentation.requestFields;
import static org.springframework.restdocs.payload.PayloadDocumentation.responseFields;
import static org.springframework.restdocs.request.RequestDocumentation.parameterWithName;
import static org.springframework.restdocs.request.RequestDocumentation.partWithName;
import static org.springframework.restdocs.request.RequestDocumentation.requestParameters;
import static org.springframework.restdocs.request.RequestDocumentation.requestParts;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.multipart;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.ResultActions;

import net.herit.svcplatform.pushservice.base.bases.RestDocsBaseWithSpringBoot;
import net.herit.svcplatform.pushservice.base.restdoc.RestDocAttributes;
import net.herit.svcplatform.pushservice.features.logger.DefaultModel;
import net.herit.svcplatform.pushservice.features.logger.RequestDto;

class LogTestRestdocsTests extends RestDocsBaseWithSpringBoot {

	@Test
	@DisplayName("Json Post 테스트 API - Restdocs 생성 테스트")
	void postController() throws Exception {
		RequestDto request = new RequestDto();
		DefaultModel defaultModel = new DefaultModel();
		defaultModel.setData("data");
		
		request.setData(defaultModel);

		ResultActions result = this.mockMvc.perform(post("/api/1.0/post")
				.contentType(MediaType.APPLICATION_JSON)
				.content(objectMapper.writeValueAsString(request))
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andDo(this.document.document(  
						defaultRequestHeader,
							requestFields(
								fieldWithPath("data.data").description("테스트 요청 data")
								.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc(""))
							)
						))
				.andExpect(jsonPath("result.code")
						.value("0"))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
								.description("result.code")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
	}
	
	@Test
	@DisplayName("multiupload 테스트 API - Restdocs 생성 테스트")
	void multiupload() throws Exception {
		MockMultipartFile image = new MockMultipartFile("filename", "<<jpg data>>".getBytes());
		MockMultipartFile image2 = new MockMultipartFile("filename", "<<jpg2 data>>".getBytes());
		
		ResultActions result = this.mockMvc.perform(
				multipart("/multiupload")
					.file(image)
					.file(image2)
					.param("data", "data")
				.contentType(MediaType.MULTIPART_FORM_DATA_VALUE)
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andDo(this.document.document(  
						defaultRequestHeader,
							requestParts(
								partWithName("filename").description("테스트 요청 filename")),
							requestParameters(
								parameterWithName("data").description("테스트 요청 data"))
							))
				.andExpect(jsonPath("result.code")
						.value("0"))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
								.description("result.code")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
	}

	@Test
	@DisplayName("form-urlencoded Get 테스트 API - Restdocs 생성 테스트")
	void getFormUrlEncodedController() throws Exception {
		ResultActions result = this.mockMvc.perform(get("/api/1.0/get/form/urlencoded")
				.contentType(MediaType.APPLICATION_FORM_URLENCODED_VALUE)
				.content("data=data")
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andDo(this.document.document(  
						defaultRequestHeader,
							requestParameters(
								parameterWithName("data").description("테스트 요청 data"))))
				.andExpect(jsonPath("result.code")
						.value("0"))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
								.description("result.code")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
	}
	
	@Test
	@DisplayName("Json Get 테스트 API - Restdocs 생성 테스트")
	void getController() throws Exception {
		RequestDto request = new RequestDto();
		DefaultModel defaultModel = new DefaultModel();
		defaultModel.setData("data");
		
		request.setData(defaultModel);

		ResultActions result = this.mockMvc.perform(get("/api/1.0/get")
				.contentType(MediaType.APPLICATION_JSON)
				.content(objectMapper.writeValueAsString(request))
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andDo(this.document.document(  
						defaultRequestHeader,
							requestFields(
								fieldWithPath("data.data")
									.description("data.data")
								.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc(""))
							)
						))
				.andExpect(jsonPath("result.code")
						.value("0"))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
								.description("result.code")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
	}

	@Test
	@DisplayName("healthCheck 테스트 API - Restdocs 생성 테스트")
	void healthCheck() throws Exception {
		
		ResultActions result = this.mockMvc.perform(post("/api/1.0/healthcheck")
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andDo(this.document.document(defaultRequestHeader))
				.andExpect(jsonPath("result.code")
						.value("0"))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
									.description("result.code")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
	}
	
}
