package net.herit.svcplatform.pushservice.restdocs.feign;

import static org.springframework.restdocs.payload.PayloadDocumentation.fieldWithPath;
import static org.springframework.restdocs.payload.PayloadDocumentation.requestFields;
import static org.springframework.restdocs.payload.PayloadDocumentation.responseFields;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTest.WebEnvironment;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.ResultActions;

import net.herit.svcplatform.pushservice.base.bases.RestDocsBaseWithSpringBoot;
import net.herit.svcplatform.pushservice.base.restdoc.RestDocAttributes;
import net.herit.svcplatform.pushservice.features.logger.DefaultModel;
import net.herit.svcplatform.pushservice.features.logger.RequestDto;

/**
 * 샘플 코드로 현재 openfeign으로 이 프로젝트의 controller에 요청을 보내고 있으므로, 
 * 테스트 성공을 위해 DEFINED_PORT 적용 ( 스프링 부트 서버는 한번 더 띄움 )
 */
@Disabled
@SpringBootTest(webEnvironment = WebEnvironment.DEFINED_PORT)
class FeignControllerRestdocsTests extends RestDocsBaseWithSpringBoot {

	@Test
	@DisplayName("feign post restdocs 생성 테스트")
	void postMappingTest() throws Exception {
		RequestDto request = new RequestDto();
		DefaultModel defaultModel = new DefaultModel();
		defaultModel.setData("data");
		
		request.setData(defaultModel);

		ResultActions result = this.mockMvc.perform(post("/api/1.0/feign/post")
				.contentType(MediaType.APPLICATION_JSON)
				.content(objectMapper.writeValueAsString(request))
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andDo(this.document.document(  
						defaultRequestHeader,
							requestFields(
								fieldWithPath("data.data").description("테스트 요청 data")
								.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc(""))
							)
						))
				.andExpect(jsonPath("result.code")
						.value("0"))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
								.description("result.code")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
		
	}
	
	@Test
	@DisplayName("feign get restdocs 생성 테스트")
	void getMappingTest() throws Exception {
		RequestDto request = new RequestDto();
		DefaultModel defaultModel = new DefaultModel();
		defaultModel.setData("data");
		
		request.setData(defaultModel);

		ResultActions result = this.mockMvc.perform(get("/api/1.0/feign/get")
				.contentType(MediaType.APPLICATION_JSON)
				.content(objectMapper.writeValueAsString(request))
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andDo(this.document.document(  
						defaultRequestHeader,
							requestFields(
								fieldWithPath("data.data").description("테스트 요청 data")
								.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc(""))
							)
						))
				.andExpect(jsonPath("result.code")
						.value("0"))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
								.description("result.code")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
		
		
	}

}
