package net.herit.svcplatform.pushservice.restdocs.commons.controller;

import static org.springframework.restdocs.payload.PayloadDocumentation.fieldWithPath;
import static org.springframework.restdocs.payload.PayloadDocumentation.responseFields;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.ResultActions;

import net.herit.svcplatform.pushservice.base.bases.RestDocsBaseWithSpringBoot;
import net.herit.svcplatform.pushservice.base.restdoc.RestDocAttributes;
import net.herit.svcplatform.pushservice.commons.dto.model.SuccessModel;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;

class HealthCheckControllerTests extends RestDocsBaseWithSpringBoot {
	
	@Test
	@DisplayName("healthcheck")
	void healthCheck() throws Exception {
		SuccessModel request = new SuccessModel();

		ResultActions result = this.mockMvc.perform(post("/api/healthcheck")
				.contentType(MediaType.APPLICATION_JSON)
				.content(objectMapper.writeValueAsString(request))
				.headers(getTestHeader()));
		
		result.andDo(print()).andExpect(status().isOk())
				.andExpect(jsonPath("result.code")
						.value(HttpResponseStatus.SUCCESS.getCode()))
				.andDo(this.document.document(
						this.defaultRequestHeader,
						responseFields(
								fieldWithPath("result.code")
									.description("결과 코드")
									.attributes(RestDocAttributes.length(Integer.MAX_VALUE), RestDocAttributes.format(""), RestDocAttributes.etc("")))));
	}
	

}
