package net.herit.svcplatform.pushservice.commons.validation.header;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

import javax.servlet.http.HttpServletRequest;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

import net.herit.svcplatform.pushservice.base.bases.MockitoBase;
import net.herit.svcplatform.pushservice.commons.dto.request.RequestHeader;

class RequestHeaderValidationTests extends MockitoBase {

	@Mock
	HttpServletRequest request;
	
	@Test
    @DisplayName("header 성공 테스트")
	void requestHeaderSuccessTest() throws Exception {
		RequestHeader requestHeader = getHeader();
		
		assertTrue(RequestHeaderValidation.headerLengthCheck(requestHeader));
	}
	
	@Test
    @DisplayName("null 실패 테스트1. headerLengthCheck()")
	void requestHeaderNullFailTest1() throws Exception {
		RequestHeader requestHeader = getHeader();
		
		String xServiceId = null;
		requestHeader.setXServiceId(xServiceId);
		
		assertFalse(RequestHeaderValidation.headerLengthCheck(requestHeader));
	}
		
	@Test
    @DisplayName("header길이 실패 테스트1. headerLengthCheck()")
	void requestHeaderLengthFailTest1() throws Exception {
		RequestHeader requestHeader = getHeader();
		
		String xServiceId = "X-SERVICE-ID-TEST, X-SERVICE-ID-TEST, X-SERVICE-ID-TEST";
		requestHeader.setXServiceId(xServiceId);
		
		assertFalse(RequestHeaderValidation.headerLengthCheck(requestHeader));
	}
	
	private RequestHeader getHeader() {
		String xServiceId = "X-SERVICE-ID-TEST";
		String xTerminalId = "X-TERMINAL-ID-TEST";
		String xAppType = "X-APP-TYPE";
		
		return new RequestHeader(xServiceId, xAppType, xTerminalId);
	}

}
