package net.herit.svcplatform.pushservice.commons.util;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotEquals;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

import com.fasterxml.jackson.core.JsonProcessingException;

import net.herit.svcplatform.pushservice.base.bases.MockitoBase;
import net.herit.svcplatform.pushservice.commons.util.JsonUtil;
import lombok.AllArgsConstructor;
import lombok.Data;

class JsonUtilTest extends MockitoBase {
	
	private JsonUtil jsonUtil;
	
	@BeforeEach
	void jsonSetUp() {
		this.jsonUtil = new JsonUtil();
	}

	@Test
	@DisplayName("object -> json 성공 테스트")
	void objectToJsonSuccessTest() throws JsonProcessingException {
		JsonUtilTestObject jsonUtilTestObject = new JsonUtilTestObject("name", "addr", 30);
		String expected = objectMapper.writeValueAsString(jsonUtilTestObject);
		assertEquals(expected, jsonUtil.objectToJson(jsonUtilTestObject));
	}
	
	@Test
	@DisplayName("object -> json 객체가 바뀌었을 경우, 실패 테스트")
	void objectToJsonFailTest() throws JsonProcessingException {
		JsonUtilTestObject jsonUtilTestObject = new JsonUtilTestObject("name", "addr", 30);
		String expected = objectMapper.writeValueAsString(jsonUtilTestObject);
		jsonUtilTestObject.setName("test");
		assertNotEquals(expected, jsonUtil.objectToJson(jsonUtilTestObject));
	}

	@Test
	@DisplayName("string -> pretty json 성공 테스트")
	void stringToPrettyJsonSuccessTest() throws JsonProcessingException {
		JsonUtilTestObject jsonUtilTestObject = new JsonUtilTestObject("name", "addr", 30);
		String json = objectMapper.writeValueAsString(jsonUtilTestObject);

		Object jsonObject = objectMapper.readValue(json, Object.class);
		String expected = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
		
		assertEquals(expected, jsonUtil.stringToPrettyJson(json));
	}
	
	@Test
	@DisplayName("string -> pretty json 실패 테스트 pretty와 1 line")
	void stringToPrettyJsonFailTest() throws JsonProcessingException {
		JsonUtilTestObject jsonUtilTestObject = new JsonUtilTestObject("name", "addr", 30);
		String json = objectMapper.writeValueAsString(jsonUtilTestObject);
		assertNotEquals(json, jsonUtil.stringToPrettyJson(json));
	}
	
	@Data
	@AllArgsConstructor
	private class JsonUtilTestObject {
		private String name;
		private String addr;
		private int age;
	}
	

}
