package net.herit.svcplatform.pushservice.base.watcher;

import java.util.Optional;

import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class TestResultHandler implements TestWatcher{
	
	public void testDisabled(ExtensionContext context, Optional<String> reason) {
		System.out.println("disabled : " + context.getDisplayName());
		System.out.println(reason);
		System.out.println(TestResultCounter.disabledCount++);
		TestResultCounter.disabledDisplayNames.add(context.getDisplayName());
	}
	
	public void testSuccessful(ExtensionContext context) {
		System.out.println("success: " + context.getDisplayName());
		System.out.println(TestResultCounter.successCount++);
		TestResultCounter.successDisplayNames.add(context.getDisplayName());
	}
	
	public void testAborted(ExtensionContext context, Throwable cause) {
		System.out.println("aborted: " + context.getDisplayName());
		System.out.println(cause);
		System.out.println(TestResultCounter.abortedCount++);
		TestResultCounter.abortedDisplayNames.add(context.getDisplayName());
	}
	
	public void testFailed(ExtensionContext context, Throwable cause) {
		System.out.println("failed: " + context.getDisplayName());
		System.out.println(cause);
		System.out.println(TestResultCounter.failCount++);
		TestResultCounter.failDisplayNames.add(context.getDisplayName());
	}
}
