package net.herit.svcplatform.pushservice.features.logger;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModelProperty;
import net.herit.svcplatform.pushservice.commons.exception.CommonException;
import net.herit.svcplatform.pushservice.commons.validation.CustomValidation;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class RequestDto implements CustomValidation {
	
	@Valid @NotNull
	@ApiModelProperty(required = true)
	private DefaultModel data;

	@Override
	public String isValid() throws CommonException {
		String result = "SUCCESS";
		
		if (data.getData().equals("error2")) {
			result = "error";
		}
		
		return result;
	}

}
