package net.herit.svcplatform.pushservice.features.kafka;

import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.features.send.PushRequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

@Service
public class KafkaConsumer {
	@Autowired
	private CallLogger call;

	@Autowired
	private PushRequestService pushRequestService;

	@Autowired
	@Qualifier("push-request-executor")
	private ThreadPoolTaskExecutor threadPoolTaskExecutor;

	@Value("${thread-pool.run-delay-ms}")
	private int runDelay;

	@KafkaListener(topics = "${spring.kafka.consumer.topic}")
	public void consume(String message) {
		call.info("message consumed:{}", message);
		try {
			TimeUnit.MILLISECONDS.sleep(runDelay);
			threadPoolTaskExecutor.execute(() -> pushRequestService.request(message));
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		}
	}
}
