package net.herit.svcplatform.pushservice.features.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;

import feign.Headers;
import net.herit.svcplatform.pushservice.commons.auth.NonAuth;

@FeignClient(name = "test", url = "http://localhost:8080")
public interface FeignService {

	@NonAuth
    @Headers({
    	"name: post"
    	})
    @PostMapping("/feign/test/post")
    public ParamB postMapping(@RequestHeader("name") String name, ParamA data);
    
    @Headers({
    	"name: get"
    	})
    @GetMapping("/feign/test/get")
    public ParamB getMapping(@RequestHeader("name") String name, ParamA data);
}
