package net.herit.svcplatform.pushservice.features.feign;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiOperation;
import net.herit.svcplatform.pushservice.commons.auth.NonAuth;
import net.herit.svcplatform.pushservice.commons.dto.model.SuccessModel;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.features.logger.RequestDto;
import net.herit.svcplatform.pushservice.features.logger.ResponseDto;
import lombok.RequiredArgsConstructor;

@RestController
@RequiredArgsConstructor
public class FeignController {
	private final CallLogger callLogger;
	private final FeignService feignService;

	@NonAuth
	@PostMapping("/api/1.0/feign/post")
	@ApiOperation(value = "[Test] feign Post 테스트", notes = "참조 테이블 : 없음")
	public ResponseEntity<ResponseDto> postMapping(@RequestBody RequestDto requestBody) {
		callLogger.info("feign/post");
		
		ParamA a = new ParamA();
		a.data = "data";
		ParamB paramB = feignService.postMapping("0", a);
		callLogger.info("{}", paramB);
		
		return ResponseEntity.ok(new ResponseDto(new SuccessModel()));
	}
	
	@GetMapping("/api/1.0/feign/get")
	@ApiOperation(value = "[Test] feign get 테스트", notes = "참조 테이블 : 없음")
	public ResponseEntity<ResponseDto> getMapping(@RequestBody RequestDto requestBody) {
		callLogger.info("feign/get");

		return ResponseEntity.ok(new ResponseDto(new SuccessModel()));
	}

}
