package net.herit.svcplatform.pushservice.commons.validation.header;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.commons.logger.OmsLogger;
import net.herit.svcplatform.pushservice.commons.logger.dto.OmsObject;

@Component
public class HeaderCheckInterceptor implements HandlerInterceptor {

	@Autowired
	OmsObject omsObject;
    @Autowired
    OmsLogger omsLogger;
    @Autowired
    CallLogger callLogger;
    
	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
			throws Exception {
		
		if(handler instanceof ResourceHttpRequestHandler) {
			request.setAttribute("svc_uri", request.getRequestURI());
			return true;
		}
		
		if(! RequestHeaderValidation.isValid(request)) {
			callLogger.info("RequestHeader validation Check is fail");
			setFailResponse(response);
			return false;
		}
		
		return true;
	}
	
	private void setFailResponse(HttpServletResponse response) throws IOException {
		omsObject.setResultCode(HttpResponseStatus.INVALID_AUTH_TOKEN.getResCode());
		omsObject.setStatusCode(HttpResponseStatus.INVALID_PARAM.getResCode());
		omsLogger.write();
		response.setContentType("application/json");
		response.setCharacterEncoding("UTF-8");
		response.getWriter().write(HttpResponseStatus.getErrorResponseToJson(HttpResponseStatus.INVALID_PARAM));
		response.setStatus(HttpResponseStatus.INVALID_PARAM.getResCode());
	}

}
