package net.herit.svcplatform.pushservice.commons.validation.body;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.springframework.beans.factory.annotation.Autowired;

import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.commons.validation.CustomValidation;

public class CustomValidImpl implements ConstraintValidator<CustomValid, CustomValidation>{

	@Autowired
	private CallLogger call;
	
	@Override
	public boolean isValid(CustomValidation value, ConstraintValidatorContext context) {
        String result = null;

        try {
			result = value.isValid();
		} catch (Exception e) {
            addViolation(context);
            return false;
		}
        
        if( ! result.equals("SUCCESS")){
        	call.info(result);
            addViolation(context);
            return false;
        }
        return true;
    }
    
    private void addViolation(ConstraintValidatorContext ctx) {
        ctx.disableDefaultConstraintViolation();
        ctx.buildConstraintViolationWithTemplate(
	        		HttpResponseStatus.INVALID_PARAM
	        		.getDescription())
                .addConstraintViolation();
    }
}