package net.herit.svcplatform.pushservice.commons.util;

import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class HttpTypeUtil {

	public boolean isJsonPost(String contentType, String methodType) {
		return isEqualsType(contentType, methodType, MediaType.APPLICATION_JSON_VALUE, HttpMethod.POST);
	}

	public boolean isFormPost(String contentType, String methodType) {
		return isEqualsType(contentType, methodType, MediaType.APPLICATION_FORM_URLENCODED_VALUE, HttpMethod.POST);
	}

	public boolean isFormDataPost(String contentType, String methodType) {
		return isEqualsType(contentType, methodType, MediaType.MULTIPART_FORM_DATA_VALUE, HttpMethod.POST);
	}

	public boolean isFormDataGet(String contentType, String methodType) {
		return isEqualsType(contentType, methodType, MediaType.MULTIPART_FORM_DATA_VALUE, HttpMethod.GET);
	}

	public boolean isJsonGet(String contentType, String methodType) {
		return isEqualsType(contentType, methodType, MediaType.APPLICATION_JSON_VALUE, HttpMethod.GET);
	}

	public boolean isFormGet(String contentType, String methodType) {
		return isEqualsType(contentType, methodType, MediaType.APPLICATION_FORM_URLENCODED_VALUE, HttpMethod.GET);
	}
	
	public boolean isOctetStream(String contentType) {
		return contentType != null &&
				contentType.equals(MediaType.APPLICATION_OCTET_STREAM_VALUE);
	}
	
	private boolean isEqualsType(String expectContentType, String expectMethodType, String actualContentType,
			HttpMethod actualMethodType) {

		return expectContentType != null && expectContentType.contains(actualContentType)
				&& actualMethodType.matches(expectMethodType);
	}
}
