package net.herit.svcplatform.pushservice.commons.transaction;

import javax.servlet.http.HttpServletRequest;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import lombok.RequiredArgsConstructor;

@Aspect
@Component
@RequiredArgsConstructor
@Profile(value = {"local", "dev"})
public class DBTransactionAop {
	private final DataSourceTransactionManager transactionManager;

	@Pointcut("@annotation(org.springframework.web.bind.annotation.PostMapping)")
	public void postMapping() {
	}
	
	@Around("postMapping()")
	public Object serviceExceptionHandler(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {

		HttpServletRequest httpServletRequest = ((ServletRequestAttributes) RequestContextHolder
				.currentRequestAttributes()).getRequest();

		Object obj = proceedingJoinPoint.proceed();
		
		if(checkSwagger(httpServletRequest) && !httpServletRequest.getRequestURI().contains("list")) {
			rollback();
		}
		
		return obj;
	}
	
	private boolean checkSwagger(HttpServletRequest request) {
		return request.getHeader("Api-Test-Tools") != null && request.getHeader("Api-Test-Tools").equals("Swagger");
	}
	
	private void rollback() {
		
		DefaultTransactionDefinition def = new DefaultTransactionDefinition();
		def.setName("swagger-rollback");
		def.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRED);
		
		TransactionStatus status = transactionManager.getTransaction(def);
		transactionManager.rollback(status);
	}
	
}