package net.herit.svcplatform.pushservice.commons.logger.dto;

import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.herit.svcplatform.pushservice.commons.logger.LogTracer;
import net.herit.common.logger.obj.abst.AbstractOmsObject;

public class OmsObject extends AbstractOmsObject implements Cloneable {
	public OmsObject request(HttpServletRequest request) {

		String svcId = request.getHeader("X-SERVICE-ID");
		String terminalId = request.getHeader("X-TERMINAL-ID");
		String transactionId = request.getHeader("X-TRANSACTION-ID");
		String appType = request.getHeader("X-APP-TYPE");
		String xForwardedFor = request.getHeader("X-Forwarded-For");

		if (svcId == null)
			svcId = "";

		if (terminalId == null)
			terminalId = "";

		if (transactionId == null)
			transactionId = "";

		if (appType == null)
			appType = "";

		if (xForwardedFor == null)
			xForwardedFor = "";
		
		String apiUri = request.getRequestURI();
		String httpVer = request.getProtocol();

		setSeqId();
		setSvcId(svcId);
		setClientIp(getClientIp(xForwardedFor));
		setHttpVer(httpVer);
		setOsInfo(appType);
		setAppType(appType);
		setTerminalId(terminalId);
		setTxId(transactionId);
		setSessionId(transactionId);
		setApiUri(apiUri);
		setResultCode(0);

		return this;
	}

	public OmsObject uri(String apiUri) {
		setApiUri(apiUri);
		return this;
	}
	
	public OmsObject requestTime(String reqTime) {
		setReqTime(reqTime);
		return this;
	}

	public OmsObject response(HttpServletResponse response) {
		setStatusCode(response.getStatus());
		return this;
	}
	
	public OmsObject responseTime(String resTime) {
		setResTime(resTime);
		return this;
	}
	public OmsObject httpStatus(int status) {
		setStatusCode(status);
		return this;
	}
	
	public OmsObject resultCode(int responseCode) {
		setResultCode(responseCode);
		return this;
	}
	public OmsObject logTrace(LogTracer logTracer) {
		if (logTracer != null) {
			setLogType(logTracer.logType());
			setApiClass(logTracer.apiClass());
			addSvcClass(logTracer.svcClass());
			setAppType(logTracer.apiAppType());
		}
		return this;
	}

	@Override
	public int objId() {
		return System.identityHashCode(this);
	}

	/**
	 * Oms 로그 형식
	 * ${seqId}|${logTime}|${logType}|${svcId}|${statusCode}|${resultCode}|${reqTime}|${resTime}|${clientIp}|${httpVer}|${osInfo}|${appType}|${terminalId}|${txId}|${userId}|${sessionId}|${apiClass}|${apiUri}|${r1|...|...|r10|}|
	 */
	@Override
	public String toLog() {
		StringBuilder sb = new StringBuilder();

		sb.append(seqId).append("|");
		sb.append(logTime).append("|");
		sb.append(logType).append("|");
		sb.append(svcId).append("|");
		sb.append(statusCode).append("|");
		sb.append(resultCode).append("|");
		sb.append(reqTime).append("|");
		sb.append(resTime).append("|");
		sb.append(clientIp).append("|");
		sb.append(httpVer).append("|");
		sb.append(osInfo).append("|");
		sb.append(appType).append("|");
		sb.append(terminalId).append("|");
		sb.append(txId).append("|");
		sb.append(userId).append("|");
		sb.append(sessionId).append("|");
		sb.append(apiClass).append("|");
		sb.append(apiUri).append("|");
		sb.append(getSvcClass()).append("|");
		sb.append(r1).append("|");
		sb.append(r2).append("|");
		sb.append(r3).append("|");
		sb.append(r4).append("|");
		sb.append(r5).append("|");
		sb.append(r6).append("|");
		sb.append(r7).append("|");
		sb.append(r8).append("|");
		sb.append(r9).append("|");
		sb.append(r10).append("|");

		return sb.toString();

	}

	@Override
	public AbstractOmsObject cloneObj() throws CloneNotSupportedException {
		
		OmsObject oms = (OmsObject) this.clone();
		oms.svcClassList = new ArrayList<String>(oms.svcClassList);
		return oms;
	}

	@Override
	protected Object clone() throws CloneNotSupportedException {
		return super.clone();
	}
	
	private static String getClientIp(String xForwardedFor) {
		
		if(xForwardedFor == null || "".equals(xForwardedFor)) return "";
		
		StringTokenizer tokenizer = new StringTokenizer(xForwardedFor, ",");
		String clientIp = tokenizer.nextToken();
		
		return clientIp==null?"":clientIp;
	}

}
