package net.herit.svcplatform.pushservice.commons.logger.advice;

import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import net.herit.svcplatform.pushservice.commons.dto.response.Response;
import net.herit.svcplatform.pushservice.commons.exception.CommonException;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.commons.logger.OmsLogger;
import net.herit.svcplatform.pushservice.commons.logger.dto.OmsObject;
import net.herit.svcplatform.pushservice.commons.util.DateUtil;
import lombok.RequiredArgsConstructor;

@Order(0)
@ControllerAdvice
@RequiredArgsConstructor
public class LoggerResponseAdvice implements ResponseBodyAdvice<Object> {
	private final OmsObject omsObj;
	private final DateUtil dateUtil;
	private final OmsLogger omsLogger;
	private final CallLogger callLogger;
	private final ObjectMapper objectMapper;

	@Override
	public boolean supports(MethodParameter parameter, Class<? extends HttpMessageConverter<?>> converterType) {
		return true;
	}

	@Override
	public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType,
			Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request,
			ServerHttpResponse response) {
		
		if (selectedContentType == MediaType.APPLICATION_JSON) {
			logWrite(body);
		}

		return body;
	}
	
	private void logWrite(Object body) {

		try {
			callLogger.info("{}", objectMapper.writeValueAsString(body));
			
			if (body instanceof Response) {

				Response responseBody = (Response) body;
				int resultCode = responseBody.resultCode();
				int responseCode = responseBody.getHttpResponseCode(resultCode);

				omsObj.resultCode(resultCode).httpStatus(responseCode)
						.responseTime(dateUtil.generateTimeStamp("yyyyMMddHHmmssSSS"));
				omsLogger.write();
			}
		} catch (JsonProcessingException e) {
			callLogger.error("ResponseAdvice Error : ", e);
		} catch (CommonException e) {
			callLogger.error("LoggerResponseAdvice Error : ", e);
		}
				
	}
	
    
}