package net.herit.svcplatform.pushservice.commons.jwt.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@Component
@ConfigurationProperties(prefix="token")
public class JwtProperties {
	private String accessTokenSecret;				// ACCESS_TOKEN secret KEY
	private String refreshTokenSecret;				// REFRESH_TOKEN secret KEY
	private String issuer;							// 토큰발급자
	private String accessTokenSubject;				// ACCESS_TOKEN 토큰제목
	private String refreshTokenSubject;				// REFRESH_TOKEN 토큰제목	
	private String audience;						// 토큰대상자
	private String typeKey;							// 토큰유형  서버
	private String typeClient;						// 토큰유형1 클라이언트
	private String typeServer;						// 토큰유형2 서버
	private String refreshTokenExpirationHour;		// REFRESH_TOKEN 만료시간
	private String refreshTokenHeader;				// REFRESH_TOKEN HEADER
}
