package net.herit.svcplatform.pushservice.commons.jwt.dto;

import net.herit.svcplatform.pushservice.commons.dto.model.SuccessModel;
import net.herit.svcplatform.pushservice.commons.dto.response.Response;
import lombok.Data;

@Data
public class ResultTokenDto implements Response {
    
	private SuccessModel result;
    
	private String accessToken;
	private String refreshToken;

	public ResultTokenDto() {
		setResult(new SuccessModel());
	}
	
	public ResultTokenDto(String accessToken, String refreshToken) {
		setAccessToken(accessToken);
		setRefreshToken(refreshToken);
		setResult(new SuccessModel());
	}
	
	@Override
	public int resultCode() {
		return result.getCode();
	}

}
