package net.herit.svcplatform.pushservice.commons.filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.filter.OncePerRequestFilter;

import net.herit.svcplatform.pushservice.commons.dto.wrapper.RequestWrapper;
import net.herit.svcplatform.pushservice.commons.util.BeanUtil;
import net.herit.svcplatform.pushservice.commons.util.HttpTypeUtil;

public class HttpWrapperFilter extends OncePerRequestFilter {

	@Override
	protected void doFilterInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse,
			FilterChain filterChain) throws ServletException, IOException {
		
		if (isWrapper(servletRequest)) {
			HttpServletRequest request = new RequestWrapper(servletRequest);
			
			filterChain.doFilter(request, servletResponse);

		} else {
			filterChain.doFilter(servletRequest, servletResponse);
		}
	}
	
	private boolean isWrapper(HttpServletRequest servletRequest) {

		String uri = servletRequest.getRequestURI();
		
		if (isSwaggerUri(uri)) {
			return false;
		}
		
		HttpTypeUtil httpTypeUtil = getHttpTypeUtil();
		
		if (httpTypeUtil == null) {
			return false;
		}
		
		String methodType = servletRequest.getMethod();
		String contentType = servletRequest.getContentType();
		
		if (
				httpTypeUtil.isJsonPost(contentType, methodType) || 
				httpTypeUtil.isJsonGet(contentType, methodType) ||
				httpTypeUtil.isFormPost(contentType, methodType) ||
				httpTypeUtil.isFormGet(contentType, methodType) || 
				contentType == null
		) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * 추가하지 않아도 swagger는 작동하나, 비정상적인 log가 지저분하게 남아서 추가
	 */
	private boolean isSwaggerUri(String uri) {
		return uri.indexOf("swagger") != -1 || uri.indexOf("v2/api-docs") != -1 ;
	}
	
	private HttpTypeUtil getHttpTypeUtil() {
		HttpTypeUtil bean = null;
		Object obj = BeanUtil.getBean("httpTypeUtil");
		
		if (obj instanceof HttpTypeUtil) {
			bean = (HttpTypeUtil) obj;
		}
		
		return bean;
	}

}
