package net.herit.svcplatform.pushservice.commons.dto.request;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class RequestHeader {

	private String xServiceId;
	private String xTerminalId;
	private String xAppType;

	private Map<String, String> headerMap;
	
	public RequestHeader(HttpServletRequest request) {
		toMap(request);
		headerSetting(request);
	}
	
	public RequestHeader(String xServiceId, String xAppType, String xTerminalId) {
		setXServiceId(xServiceId);
		setXAppType(xAppType);
		setXTerminalId(xTerminalId);
	}
	
	private void headerSetting(HttpServletRequest request) {
		setXServiceId(request.getHeader("X-SERVICE-ID"));
		setXAppType(request.getHeader("X-APP-TYPE"));
		setXTerminalId(request.getHeader("X-TERMINAL-ID"));
	}
	
	private void toMap(HttpServletRequest request) {
		
		headerMap = new HashMap<>();
		
		Enumeration<String> headerNames = request.getHeaderNames();
		while(headerNames.hasMoreElements()) {
			
			String hName = headerNames.nextElement();
			String hVal = request.getHeader(hName);
		
			headerMap.put(hName, hVal);
		}
	}

}
