package net.herit.svcplatform.pushservice.commons.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;


/**
 * Swagger 설정
 * 밑에 parameters로 전역으로 사용되는 변수(?)를 적을 수 있다.
 * 아래 예는 header 값을 설정해주는 내용
 */
@Configuration
@EnableSwagger2
public class SwaggerConfig {
	
	private static final String STRING = "String";

    @Bean
    public Docket api() { 
        return new Docket(DocumentationType.SWAGGER_2)  
                .globalOperationParameters(parameters())
                .select()
                .apis(RequestHandlerSelectors.any())
                .paths(PathSelectors.ant("/api/1.0/**"))
                .build()
                .apiInfo(apiInfo())
                .securitySchemes(
                		Arrays.asList(
                				new ApiKey("JWT", "Authorization", "header")
                				)
                		)
                .securityContexts(Arrays.asList(securityContext()));
    }

    private List<Parameter> parameters(){

    	List<Parameter> parameters = new ArrayList<>();

        parameters.add(
        		addHeader(
        				"Api-Test-Tools", 
        				"스웨거인 경우 DB Rollback을 시키기 위함", 
        				"String", 
        				true, 
        				"Swagger")
        		
        		);
        
    	parameters.add(
    			addHeader(
    					"X-SERVICE-ID", 
    					"다수 서비스 앱을 사용하는 경우 서비스를 식별하기 위한 코드. NOTE : 설치기사 앱은 'HEVITON' 으로 고정", 
    					STRING, 
    					true, 
    					"HEVITON"
    					)
    			);
    	
    	parameters.add(
    			addHeader(
    					"X-APP-TYPE", 
    					"ios / android", 
    					STRING, 
    					true, 
    					"android"
    					)
    			);
    	
    	parameters.add(
    			addHeader(
    					"X-TERMINAL-ID", 
    					"동일 사용자 계정으로 여러 폰으로 로그인할 경우 별도의 세션 처리 (동시로그인 허용) 앱 설치 후 최초실행 시 UUID 형식의 문자열 형식으로 X-TERMINAL-ID 생성", 
    					STRING, 
    					true, 
    					"55a0fa94-5ab8-4498-9517-46876b96db0d"
    					)
    			);
    	
    	parameters.add(
    			addHeader(
    					"X-API-VERSION", 
    					"1.0", 
    					STRING, 
    					true, 
    					"1.0"
    					)
    			);
    	
    	parameters.add(
    			addHeader(
    					"X-REFERER", 
    					"페이지 단위를 구분하기 위한 코드. NOTE : 앱로깅 API의 function.code와 동일", 
    					STRING, 
    					true, 
    					"REFERER"
    					)
    			);
    	
    	parameters.add(
    			addHeader(
    					"X-TRANSACTION-ID", 
    					"서비스 플랫폼 또는 API_GW 에서 생성", 
    					STRING, 
    					true, 
    					"X-TRANSACTION-ID.20200629115826"
    					)
    			);
    	
    	parameters.add(
    			addHeader(
    					"Authorization", 
    					"token", 
    					STRING, 
    					false, 
    					""
    					)
    			);

		return parameters;
    }
    
    private ApiInfo apiInfo() {
    	
    	return new ApiInfoBuilder()
    			.title("Rookie API TEST")
    			.description("Rookie 서비스 api 테스트 페이지.")
    			.version("0.1")
    			.build();

    }
    
    private Parameter addHeader(String name, String desc, String headerType, boolean required, String defaultValue) {
    	return new ParameterBuilder().
    			name(name)
    			.description(desc)
    			.modelRef(new ModelRef(headerType))
    			.parameterType("header")
    			.required(required)
    			.defaultValue(defaultValue)
    			.build();
    	
    }
    
   
    
    private List<SecurityReference> defaultAuth(){
    	AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
    	AuthorizationScope[] authorizationScopes = new AuthorizationScope[1];
    	authorizationScopes[0] = authorizationScope;
    	
    	return Arrays.asList(
    			new SecurityReference("JWT", authorizationScopes)
    			);
    	
    }
    
    private SecurityContext securityContext() {
    	return SecurityContext.builder()
    			.securityReferences(defaultAuth())
    			.forPaths(PathSelectors.ant("/api/1.0/**"))
    			.build();
    }
    
}