package net.herit.svcplatform.pushservice.commons.auth;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import net.herit.svcplatform.pushservice.commons.dto.model.AccountModel;
import net.herit.svcplatform.pushservice.commons.dto.request.AuthRequest;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.exception.AopException;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import lombok.RequiredArgsConstructor;

@Component
@RequiredArgsConstructor
public class TokenCheck {
	private final CallLogger callLogger;
	private final AuthService authService;

	void tokenCheck(Object[] args) {
		callLogger.info("net.herit.svcplatform.pushservice.commons.auth.TokenCheck.tokenCheck() start");
		
		boolean result = false;

		for (Object arg : args) {
			if (arg instanceof AuthRequest) {
				result = true;

				AuthRequest authRequest = (AuthRequest) arg;
				AccountModel account = authRequest.getAccount();

				if (account == null) {
					throw new AopException(HttpResponseStatus.NOT_EXIST_USER);
				}

				String loginId = account.getLoginId();
				String authToken = account.getAuthToken();

				HttpServletRequest httpServletRequest = ((ServletRequestAttributes) RequestContextHolder
						.getRequestAttributes()).getRequest();

				String svcId = httpServletRequest.getHeader("X-SERVICE-ID");
				String terminalId = httpServletRequest.getHeader("X-TERMINAL-ID");

				if (loginId == null || authToken == null || svcId == null || terminalId == null) {
					throw new AopException(HttpResponseStatus.NOT_EXIST_USER);
				}

				boolean authCheck = authService.authTokenCheck(loginId, authToken, svcId, terminalId);

				if (!authCheck) {
					throw new AopException(HttpResponseStatus.NOT_EXIST_USER);
				}
			}
		}
		
		if (! result) {
			throw new AopException(HttpResponseStatus.NOT_EXIST_USER);
		}
		
		callLogger.info("net.herit.svcplatform.pushservice.commons.auth.TokenCheck.tokenCheck end");
	}

}
