package net.herit.svcplatform.pushservice.commons.auth;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Component;

import io.jsonwebtoken.Claims;
import net.herit.svcplatform.pushservice.commons.dto.response.HttpResponseStatus;
import net.herit.svcplatform.pushservice.commons.exception.AopException;
import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import net.herit.svcplatform.pushservice.commons.util.JwtUtil;
import lombok.RequiredArgsConstructor;

// TODO DB 작업은 따로 되어있지 않으므로, DB 인증과정 추가 필요
@Component
@RequiredArgsConstructor
public class JwtCheck {
	private final JwtUtil jwtUtil;
	private final CallLogger callLogger;
	private final AuthService authService;

	void jwtCheck(HttpServletRequest request, String jwt) {
		callLogger.info("net.herit.svcplatform.pushservice.commons.auth.JwtCheck.jwtCheck() start");
		
		try {
			Claims claims = jwtUtil.decodeAccessToken(jwt);
			callLogger.info("claims: {}", claims);
			
			// TODO 클라이언트 인증만 허용하도록 설정
			if (!claims.get("typ").equals("1")) {
				throw new AopException(HttpResponseStatus.INVALID_JWT_TOKEN);
			}
			
			
		} catch (Exception e) {
			throw new AopException(HttpResponseStatus.INVALID_JWT_TOKEN);
		}
		
		if (!authService.jwtCheck()) {
			throw new AopException(HttpResponseStatus.INVALID_JWT_TOKEN);
		}
		
	}
}
