package net.herit.svcplatform.pushservice.commons.auth;

import javax.servlet.http.HttpServletRequest;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import net.herit.svcplatform.pushservice.commons.logger.CallLogger;
import lombok.RequiredArgsConstructor;

@Aspect
@Component
@RequiredArgsConstructor
public class AuthAop {
	private final CallLogger callLogger;
	private final TokenCheck tokenCheck;
	private final JwtCheck jwtCheck;
	
	@Pointcut("@annotation(org.springframework.web.bind.annotation.PostMapping)")
	public void PostMapping() {};
	
	@Around("PostMapping()")
	public Object authCheck(ProceedingJoinPoint pjp) throws Throwable {
		callLogger.info("AuthAop => Start");

		HttpServletRequest httpServletRequest = ((ServletRequestAttributes) RequestContextHolder
				.currentRequestAttributes()).getRequest();

		String jwt = httpServletRequest.getHeader("Authorization");
		
		if (isNonAuth(pjp)) return pjp.proceed();
		
		 // TODO Header 에 Authorization 정보가 있는 경우에만 jwt 확인 -> 확인 필요
		if (jwt != null && !jwt.equals("")) {
			jwtCheck.jwtCheck(httpServletRequest, jwt);
		} else {
			tokenCheck.tokenCheck(pjp.getArgs());
		}
		
		return pjp.proceed();
	}
	
	private boolean isNonAuth(ProceedingJoinPoint pjp) {
		boolean result = false;
		
		if (pjp.getSignature() instanceof MethodSignature) {
			MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
			NonAuth nonAuth = methodSignature.getMethod().getAnnotation(NonAuth.class);
			
			result = nonAuth != null;
		}
		
		return result;
	}
}
