package net.herit.ami.features.stat.service.snd;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.exception.CommonException;
import net.herit.ami.commons.exception.ExceptionType;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.features.stat.dto.SndXmlDTO.SndDTO;
import net.herit.ami.features.stat.dto.SndXmlDTO.SndRoot;
import net.herit.ami.features.stat.repository.dataportal.SndRepository;
import net.herit.ami.features.stat.service.ResponseService;
import org.springframework.stereotype.Service;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import java.io.StringReader;
@Service
@RequiredArgsConstructor
public class SndService {
    private final CallLogger call;
    private final ResponseService responseService;
    private final SndEnterFeignClient sndEnterFeignClient;
    private final SndRepository sndRepository;
    public int makeSndDTO (String serviceKeys)  {
        SndDTO snd =  xmlToSndRoot(serviceKeys).getBody().getItems().getItem();
        call.debug("explorerSnd item pasing : {}", snd);
        return sndRepository.insertSnd(snd);
    }
    public SndRoot xmlToSndRoot(String serviceKeys)  {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(SndRoot.class);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            String resString=responseService.responseXmlToString(sndEnterFeignClient.requestConsumeData(serviceKeys));
            return (SndRoot) unmarshaller.unmarshal(new StringReader(resString));
        } catch (JAXBException e) {
            throw new CommonException(ExceptionType.XML_TO_OBJECT_EXCEPTION);
        }
    }
}
