package net.herit.ami.features.stat.service.snd;

import lombok.RequiredArgsConstructor;
import net.herit.ami.commons.logger.call.log.CallLogger;
import net.herit.ami.commons.service.JobService;
import net.herit.ami.features.stat.job.SndEnterConsumeDataJob;
import net.herit.ami.features.stat.property.SndEnterConsumeDataProperty;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;

@Service
@RequiredArgsConstructor
public class SndConsumeDataJobService implements JobService {

    private static final String NAME ="SndConsumeDataJobService";

    private static final String GROUP = "STAT";

    private final SndEnterConsumeDataProperty property;

    private final Scheduler scheduler;

    private final CallLogger call;
    @Override
    public void initBatch() {

        JobDetail jobDetail = buildJobDetail(SndEnterConsumeDataJob.class, NAME, GROUP, new HashMap<>());

        try {
            if(property.isEnable())
                scheduler.scheduleJob(jobDetail, buildJobTrigger(property.getSchedule()));
        } catch (SchedulerException e) {
            call.error("FileReaderService :: scheduler error :: {}", LocalDateTime.now());
        }

    }

}
