package net.herit.ami.features.stat.service.smp;

import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@FeignClient(value = "smp-enter", url = "${dataportal.host}")
public interface SmpEnterFeignClient {

    /**
     * 서비스에 동의한 회원 전체의 date 전기소비량을 조회합니다.
     *
     * @param area : 지역구분 (육지 : 1, 제주도 : 9)
     * @param serviceKey : api 인증키
     * @return
     */
    @GetMapping(value = "${dataportal.smp.uri-request-consume-data}")
    Response requestConsumeDataByAll(
            @RequestParam(name = "areaCd") int area,
            @RequestParam("serviceKey") String serviceKey
    );
}
